; ====================================================================================================
;
; explosion.asm
;
; included from sprite.asm
;
; ====================================================================================================
SECTION code_user

CHRNO_EXPLOSION:        EQU 3       ; キャラクター番号

; ====================================================================================================
; バクハツ初期化
; ====================================================================================================
INIT_EXPLOSION:
    PUSH IX
    XOR A
    CALL GET_SPR_WK_ADDR
    PUSH IX
    POP HL
    POP IX

    LD (IX),CHRNO_EXPLOSION         ; キャラクター番号=バクハツ

    INC HL
    INC HL
    LD A,(HL)
    LD (IX+1),0                     ; Y座標(小数部)
    LD (IX+2),A                     ; Y座標(整数部)

    INC HL
    INC HL
    LD A,(HL)
    LD (IX+3),0                     ; X座標(小数部)
    LD (IX+4),A                     ; X座標(整数部)

    LD (IX+5),24                    ; スプライトパターンNo
    LD (IX+6),9                     ; カラーコード

    LD A,(INIT_EXPLOSION_DIRECTION)
    LD (IX+7),A                     ; 移動方向
    LD (IX+8),$FF                   ; 移動量
    LD (IX+9),0                     ; アニメーションテーブルアドレス
    LD (IX+10),0                    ; アニメーションテーブルアドレス
    LD (IX+11),12                   ; アニメーションカウンタ

    RET


; ====================================================================================================
; バクハツ処理サブルーチン
; ====================================================================================================
UPDATE_EXPLOSION:
    CALL SPRITE_MOVE                ; スプライトキャラクター移動処理

    ; ■アニメーションカウンタ減算
    DEC (IX+11)                     ; アニメーションカウンタ -1
    RET NZ                          ; ゼロ以外なら終了

    ; ■アニメーションカウンタ=0の時の処理
    LD (IX+11),12                   ; アニメーションカウンタリセット

    INC (IX+5)                      ; スプライトパターン番号 +1

    LD A,(IX+5)
    CP 28
    RET NZ                          ; スプライトパターン番号 != 28なら抜ける

UPDATE_EXPLOSION2_L1:
    ; ■スプライトパターンテーブルから削除
    CALL DEL_CHARACTER

    RET


; ====================================================================================================
; ワークエリア
; プログラム起動時にcrtでゼロでramに設定される 
; ====================================================================================================
SECTION bss_user

; ■方向の初期設定値
INIT_EXPLOSION_DIRECTION:
    DEFS 1
